/*global define, require, console, nmlImpl */
/*jslint white: true, nomen: true */

define([	"lib/Zoot"],
function(	Z) {
	'use strict';

	var kAbout = "$$$/private/animal/Behavior/FrameRateLogger/About=FrameRateLogger, (c) 2014.",
		kSamples = "samples";

	return {
		about: kAbout,
		description: "$$$/private/animal/Behavior/FrameRateLogger/Desc=Report average frame rate.",
		uiName: "$$$/private/animal/Behavior/FrameRateLogger/UIName=Frame Rate Logger",
		hideInBehaviorList: true,
		defaultArmedForRecordOn: true,
	
		defineParams: function () { 
			return [
				{
					id: kSamples,
					type:"slider",
					uiName: "$$$/private/animal/Behavior/FrameRateLogger/Parameter/samplesize=Sample Size",
					min:10, max:500, precision:0, dephault:100
				}
			];
		},
		
		onCreateBackStageBehavior: function (self) {
		},
		
		onCreateStageBehavior: function (self, backstageBehavior, stagePuppet) {
		},
		
		onParamChanged: function (self, args)  {
		},
		
		onAnimate: function (self, args) {
			var sampleSize = args.getParam(kSamples), t = args.t + args.globalRehearseTime;

			if (self.timeLast) {
				self.timeSum += t - self.timeLast;
				self.timeLast = t;
				self.timeCount += 1;
			} else {
				self.timeLast = t;
				self.timeCount = 0;
				self.timeSum = 0;
			}

			if (self.timeCount > sampleSize) {
				var spf = self.timeSum / self.timeCount,
					fps = 1.0 / spf;
				console.log(
					"average dt: " + fps.toFixed(1) + "fps/" + spf.toFixed(2) + "s" + 
					"; scene dt: " + 1.0 / args.dt.toFixed(1) + "fps/" + args.dt.toFixed(2) + "s");
				delete self.timeLast;
			}
		}
	}; // end of object being returned
});